class DamageMut extends Mutator;

var bool Init;
var string 	GooGun[50],
		PulseGun[50],
		minigun[50];

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	settimer(1.0, true);
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int score;
local int MaxScore;
	
	if (InstigatedBy.IsA('ScriptedPawn'))
		return;

	if (InstigatedBy.IsA('PlayerPawn'))
		{
		score = PlayerPawn(InstigatedBy).PlayerReplicationInfo.Score;
		}
	else if (InstigatedBy.IsA('Bot'))
		{
		score = Bot(InstigatedBy).PlayerReplicationInfo.Score;
		}
	if ( InstigatedBy.IsA('PlayerPawn') || InstigatedBy.IsA('Bot'))
     		{
		if (Victim.IsA('ScriptedPawn'))
			{
			//Add 25% of the damage taken to players score
			MaxScore = Victim.Health;
			if ( ActualDamage > MaxScore )
				{
				InstigatedBy.PlayerReplicationInfo.Score += MaxScore * 0.25;
				}
			else
				{
				InstigatedBy.PlayerReplicationInfo.Score += ActualDamage * 0.25;
				}
			//check if player is ranking as Private
			if ( score >= 20000 && score < 40000)
				{
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 200)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount++;
					}
				}
			//check if player is ranking as Corporal
			else if ( score >= 40000 && score < 60000)
				{
				InstigatedBy.Health += ActualDamage * 0.05;
				if ( InstigatedBy.Health > 300 )
					{
					InstigatedBy.Health = 300;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 200)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount++;
					}
				}
			//check if player is ranking as Sergeant
			else if ( score >= 60000 && score < 80000)
				{
				InstigatedBy.Health += ActualDamage * 0.05;
				if ( InstigatedBy.Health > 300 )
					{
					InstigatedBy.Health = 300;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 200)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 2;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 200)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 200;
						}
					}
				}
			//check if player is ranking as Staff Sergeant
			else if ( score >= 80000 && score < 100000)
				{
				InstigatedBy.Health += ActualDamage * 0.1;
				if ( InstigatedBy.Health > 300 )
					{
					InstigatedBy.Health = 300;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 200)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 2;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 200)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 200;
						}
					}
				}
			//check if player is ranking as Sergeant First Class
			else if ( score >= 100000 && score < 120000)
				{
				InstigatedBy.Health += ActualDamage * 0.1;
				if ( InstigatedBy.Health > 300 )
					{
					InstigatedBy.Health = 300;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 200)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 3;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 200)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 200;
						}
					}
				}
			//check if player is ranking as Master Sergeant
			else if ( score >= 120000 && score < 150000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 300 )
					{
					InstigatedBy.Health = 300;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 200)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 3;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 200)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 200;
						}
					}
				}
			//check if player is ranking as Second Lieutenant
			else if ( score >= 150000 && score < 200000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 300 )
					{
					InstigatedBy.Health = 300;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 250)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 3;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 250)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 250;
						}
					}
				}
			//check if player is ranking as first Lieutenant
			else if ( score >= 200000 && score < 400000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 350 )
					{
					InstigatedBy.Health = 350;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 250)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 3;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 250)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 250;
						}
					}
				}
			//check if player is ranking as Captain
			else if ( score >= 400000 && score < 800000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 400 )
					{
					InstigatedBy.Health = 400;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 250)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 3;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 250)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 250;
						}
					}
				}
			//check if player is ranking as Major
			else if ( score >= 800000 && score < 1200000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 400 )
					{
					InstigatedBy.Health = 400;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 300)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 3;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 300)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 300;
						}
					}
				}
			//check if player is ranking as Colonel
			else if ( score >= 1200000 && score < 1800000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 400 )
					{
					InstigatedBy.Health = 400;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 300)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 4;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 300)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 300;
						}
					}
				}
			//check if player is ranking as 1star General
			else if ( score >= 1800000 && score < 2400000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 400 )
					{
					InstigatedBy.Health = 400;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 350)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 4;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 350)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 350;
						}
					}
				}
			//check if player is ranking as 2star General
			else if ( score >= 2400000 && score < 3000000)
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 450 )
					{
					InstigatedBy.Health = 450;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 350)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 4;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 350)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 350;
						}
					}
				}
			//else player is a Marshal
			else if ( score >= 3000000 )
				{
				InstigatedBy.Health += ActualDamage * 0.15;
				if ( InstigatedBy.Health > 500 )
					{
					InstigatedBy.Health = 500;
					}
				if ( InstigatedBy.Weapon.AmmoType.AmmoAmount < 350)
					{
					InstigatedBy.Weapon.AmmoType.AmmoAmount += 4;
					if ( InstigatedBy.Weapon.AmmoType.AmmoAmount > 350)
						{
						InstigatedBy.Weapon.AmmoType.AmmoAmount = 350;
						}
					}
				}	
			}
     		}
	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function Timer()
{
	PlayerNewWeapon();
}

function PlayerNewWeapon()
{
local int i,score;
local Pawn P;
local string PN;
local bool bGooGun;
local bool bPulseGun;
local bool bminigun;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			score = PlayerPawn(P).PlayerReplicationInfo.Score;
			PN = PlayerPawn(P).PlayerReplicationInfo.PlayerName;
			}
		else if (P.IsA('Bot'))
			{	
			score = Bot(P).PlayerReplicationInfo.Score;
			PN = Bot(P).PlayerReplicationInfo.PlayerName;
			}
		//Run check to see what weapons the player has got already
		for (i=0;i<50;i++)
			{
			if ( GooGun[i] == PN )
				{
				bGooGun = True;
				}
			if ( PulseGun[i] == PN )
				{
				bPulseGun = True;
				}
			if ( minigun[i] == PN )
				{
				bminigun = True;
				}
			}

		//Check to see if player gets the Goo Gun
		if ( score >= 150000 && !bGooGun)
			{
			DeathMatchPlus(Level.Game).GiveWeapon(P,"MHXv3.Weap_biorifle");
			for (i=0;i<50;i++)
				{
				if ( GooGun[i] == "" )
					{
					GooGun[i] = PN;
					i = 500;
					}
				}
			}
		//Check to see if player gets the PulseGun
		if ( score >= 200000 && !bPulseGun)
			{
			DeathMatchPlus(Level.Game).GiveWeapon(P,"MHXv3.Weap_PulseGun");
			for (i=0;i<50;i++)
				{
				if ( PulseGun[i] == "" )
					{
					PulseGun[i] = PN;
					i = 500;
					}
				}
			}
		//Check to see if player gets the minigun
		if ( score >= 400000 && !bminigun)
			{
			DeathMatchPlus(Level.Game).GiveWeapon(P,"MHXv3.Weap_minigun2");
			for (i=0;i<50;i++)
				{
				if ( minigun[i] == "" )
					{
					minigun[i] = PN;
					i = 500;
					}
				}
			}
		}
}

defaultproperties
{
}
